package com.logianalytics.plugins;

import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;

import com.logixml.plugins.LogiPluginObjects10;

/*
 * Simple Logging uses web server containers logger to log event details
 * Requires Info plugin call to pass parameter, which are concatenated into a single string
 * Setup Event Logging in Info to record activity
 * Configure logging in web server to "com.logianalytics.info.logging" to record to file 
 */
public class SimpleLogging {
	
	public SimpleLogging() {
		// TODO Auto-generated constructor stub
	}
	
	public void logEvent (LogiPluginObjects10 obj) {
		Logger log = Logger.getLogger(SimpleLogging.class.getName());
		Set<String> keys = obj.getPluginParameters().keySet();
		String stringtolog = "";
		//obj.addDebugMessage("", "param count", String.valueOf(obj.getPluginParameters().size()));
		for (String key: keys) {
			//obj.addDebugMessage("", "param", key.concat(":").concat((String) obj.getPluginParameters().get(key)));
			stringtolog = stringtolog + key + ": \"" + ((String) obj.getPluginParameters().get(key))+ "\", ";
			//obj.addDebugMessage("","log string", stringtolog);
		}
		//obj.addDebugMessage("", "log string", stringtolog);
		stringtolog = stringtolog.replaceAll(", $", "");
		log.info(stringtolog);
	}

}
