package com.logianalytics.plugins;

import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Logger;

import com.logixml.plugins.LogiPluginObjects10;

/*
 * Logging using Log4j library
 * Requires Info plugin call to pass parameter, which are concatenated into a single string
 * Setup log4j.xml or log4j.properties in WEB-INF/class
 * Setup Event Logging in Info to record activity
 */
public class SimpleLoggingWithLog4j {
	static Logger log = Logger.getLogger(SimpleLoggingWithLog4j.class);

	public SimpleLoggingWithLog4j() {
		// TODO Auto-generated constructor stub
	}
		
	public void logEvent (LogiPluginObjects10 obj) {
		Set<String> keys = obj.getPluginParameters().keySet();
		String stringtolog = "";
		for (String key: keys) {
			stringtolog = stringtolog + key + ": \"" + ((String) obj.getPluginParameters().get(key))+ "\", ";
		}
		stringtolog = stringtolog.replaceAll(", $", "");
		log.info(stringtolog);
	}

}
