
'How to write a Plugin:
'-------------------------
'First, examine this sample plugin DLL, and the lgxReportDev Sample Plugin application.
'Include rdPlugin.dll in the references.
'Routines called by lgxReportDev must have a single parameter; rdPlugin.rdServerObjects.
'Return information back to lgxReportDev by changing values in rdServerObjects,
'  such as the CurrentDefinition, or Session variables.

'How to deploy a Plugin:
'-------------------------
'The output DLLs go into _Plugins folder next to bin in the ReportDev project.

'How to debug a Plugin:
'-------------------------
'Right-click the project name from the Solution Explorer and choose Properties. 
'Click Common Properties > References Path. 
'Ensure that the path points to the bin folder of the LGX application using the plug-in. 
'Click Configuration Properties > Build. 
'Ensure that the Output Path points to the _Plugins folder of the LGX application using the plug-in. 
'Click Configuration Properties > Debugging. 
'Select the "Startup URL" option. 
'Set the Start URL.  It is the URL used to access the LGX application, like "http://localhost/myweb/rdPage.aspx?rdReport=myReport".
'Check "ASP.NET Debugging".
'Click Apply to save the changes, then click OK. 
'In the web folder's web.config file, set debug=true, like:
'		<compilation defaultLanguage="vb" debug="true" />
'When compiling, you may see this error: "Could not copy temporary files to the output directory."
'Either restart the ASP.NET process or the IIS server.  (The iisreset.exe command is convenient for this purpose.)

'

Imports System.Xml

Public Class Plugin

    ''''''''''''''''''''''''''''''''''''''
    Public Sub SetApplicationCaption(ByRef rdObjects As rdPlugin.rdServerObjects)
        Dim xmlSettings As New XmlDocument()
        xmlSettings.LoadXml(rdObjects.CurrentDefinition)
        Dim eleApp As XmlElement = xmlSettings.SelectSingleNode("//Setting/Application")
        eleApp.SetAttribute("Caption", "Greetings from the Sample Plugin!  Time: " & Now.ToString)
        rdObjects.CurrentDefinition = xmlSettings.OuterXml
    End Sub

    ''''''''''''''''''''''''''''''''''''''
    Public Sub SetCustomerQuery(ByRef rdObjects As rdPlugin.rdServerObjects)
        Dim xmlDefinition As New XmlDocument()
        xmlDefinition.LoadXml(rdObjects.CurrentDefinition)
        Dim eleDataLayer As XmlElement = xmlDefinition.SelectSingleNode("//Report/Body/DataTable/DataLayer")
        If IsNothing(eleDataLayer) Then
            Throw New Exception("The report is missing the DataLayer element.")
        End If

        'Use a Request variable to set set the SELECT query.
        Dim sSelect As String
        Select Case rdObjects.Request("Continent")
            Case "NA"
                sSelect = "SELECT * FROM Customers WHERE Country IN('USA','Mexico','Canada')"
            Case "SA"
                sSelect = "SELECT * FROM Customers WHERE Country IN('Argentina','Brazil','Venezuela')"
            Case "EU"
                sSelect = "SELECT * FROM Customers WHERE Country IN('UK','Sweden','France','Spain','Switzerland','Austria','Portugal','Ireland','Belgium','Germany','Finland','Poland','Denmark')"
            Case Else
                sSelect = "SELECT * FROM Customers"
        End Select

        eleDataLayer.SetAttribute("Source", sSelect)
        rdObjects.CurrentDefinition = xmlDefinition.OuterXml
    End Sub

    ''''''''''''''''''''''''''''''''''''''
    Public Sub GetProducts(ByRef rdObjects As rdPlugin.rdServerObjects)
        Dim xmlData As System.Xml.XmlDocument = rdObjects.CurrentData
        Dim sDataLayerParentID As String = rdObjects.PluginParameters("DataLayerParentID")

        Dim eleRow As XmlElement

        eleRow = xmlData.DocumentElement.AppendChild(xmlData.CreateElement(sDataLayerParentID))
        eleRow.SetAttribute("ProductName", "Milk")

        eleRow = xmlData.DocumentElement.AppendChild(xmlData.CreateElement(sDataLayerParentID))
        eleRow.SetAttribute("ProductName", "Bread")

        eleRow = xmlData.DocumentElement.AppendChild(xmlData.CreateElement(sDataLayerParentID))
        eleRow.SetAttribute("ProductName", "Beer")


    End Sub

    ''''''''''''''''''''''''''''''''''''''
    Public Sub AddPriceColumn(ByRef rdObjects As rdPlugin.rdServerObjects)
        Dim xmlData As System.Xml.XmlDocument = rdObjects.CurrentData
        Dim sColumnName As String = rdObjects.PluginParameters("PriceColumnName")

        Dim eleRow As XmlElement
        For Each eleRow In xmlData.SelectNodes("/rdData/*")
            Select Case eleRow.GetAttribute("ProductName")
                Case "Milk"
                    eleRow.SetAttribute(sColumnName, "3.25")
                Case "Bread"
                    eleRow.SetAttribute(sColumnName, "3.75")
                Case "Beer"
                    eleRow.SetAttribute(sColumnName, "4.50")
            End Select
        Next
    End Sub

    ''''''''''''''''''''''''''''''''''''''
    Public Sub SetDataTableColumns(ByRef rdObjects As rdPlugin.rdServerObjects)
        Dim sDataTableID As String = rdObjects.PluginParameters("DataTableID")
        Dim xmlDefinition As New XmlDocument()
        xmlDefinition.LoadXml(rdObjects.CurrentDefinition)
        Dim eleDataTable As XmlElement = xmlDefinition.SelectSingleNode("//*[@ID='" & sDataTableID & "']")

        Dim xmlData As System.Xml.XmlDocument = rdObjects.CurrentData
        Dim eleFirstRow As XmlElement = xmlData.SelectSingleNode("/rdData/*")
        If Not IsNothing(eleFirstRow) Then
            Dim atr As XmlAttribute
            For Each atr In eleFirstRow.Attributes
                'Create a new DataTableColumn element under the DataTable.
                Dim eleDataTableColumn As XmlElement = eleDataTable.AppendChild(xmlDefinition.CreateElement("DataTableColumn"))
                eleDataTableColumn.SetAttribute("ID", "col" & atr.Name)
                eleDataTableColumn.SetAttribute("Header", atr.Name)
                'Create the Label element
                Dim eleLabel As XmlElement = eleDataTableColumn.AppendChild(xmlDefinition.CreateElement("Label"))
                eleLabel.SetAttribute("ID", "lbl" & atr.Name)
                eleLabel.SetAttribute("Caption", "@Data." & atr.Name & "~")
            Next
        End If

        rdObjects.CurrentDefinition = xmlDefinition.OuterXml
    End Sub

    ''''''''''''''''''''''''''''''''''''''
    Public Sub subHighlightText(ByRef rdObjects As rdPlugin.rdServerObjects)
        With rdObjects
            Dim sElementID As String = .PluginParameters("ElementID")
            Dim sFindInputName As String = .PluginParameters("FindInputName")
            Dim sStyle As String = .PluginParameters("Style")
            Dim sFindValue As String = .Request.Form(sFindInputName)
            If IsNothing(sFindValue) Then sFindValue = .Request(sFindInputName)
            If Not IsNothing(sFindValue) AndAlso sFindValue.Length <> 0 Then

                'Load the ResponsesHtml string into an XmlDocument object.
                Dim xmlHtml As New XmlDocument()
                xmlHtml.LoadXml(.ResponseHtml)
                'Find all SPAN elements under the element with the specified ElementID.
                Dim nlSpans As XmlNodeList = xmlHtml.SelectNodes("//*[@id='" & sElementID & "']//SPAN")
                Dim eleSpanText As XmlElement
                For Each eleSpanText In nlSpans
                    'Split the SPAN into 3 SPANs to highlight the first match.
                    Call subSplitHighlightSpan(xmlHtml, eleSpanText, sFindValue, sStyle)
                Next

                .ResponseHtml = xmlHtml.OuterXml
            End If
        End With
    End Sub
    Private Sub subSplitHighlightSpan(ByVal xmlHtml As XmlDocument, ByVal eleSpanText As XmlElement, ByVal sFindValue As String, ByVal sStyle As String)
        Dim nFindLocation As Integer = eleSpanText.InnerText.ToLower.IndexOf(sFindValue.ToLower)
        If nFindLocation <> -1 Then
            'The search string was found.  Break the SPAN into 3 SPANs.
            Dim sOriginal As String = eleSpanText.InnerText
            'Set the first SPAN element.
            eleSpanText.InnerText = sOriginal.Substring(0, nFindLocation)
            'Make the highlighted SPAN element.
            Dim eleNewSpan As XmlElement = eleSpanText.ParentNode.InsertAfter(xmlHtml.CreateElement("SPAN"), eleSpanText)
            eleNewSpan.SetAttribute("style", sStyle)
            eleNewSpan.InnerText = sOriginal.Substring(nFindLocation, sFindValue.Length)
            'Make the final SPAN element.
            eleNewSpan = eleSpanText.ParentNode.InsertAfter(xmlHtml.CreateElement("SPAN"), eleNewSpan)
            eleNewSpan.InnerText = sOriginal.Substring(nFindLocation + sFindValue.Length)
            'Recursively call again with this last SPAN.  There may be more matches.
            Call subSplitHighlightSpan(xmlHtml, eleNewSpan, sFindValue, sStyle)
        End If
    End Sub

    ''''''''''''''''''''''''''''''''''''''
    Public Function GetVirtualMemorySize(ByRef rdObjects As rdPlugin.rdServerObjects) As String
        Dim p As System.Diagnostics.Process = Diagnostics.Process.GetCurrentProcess
        Return p.VirtualMemorySize
    End Function

    ''''''''''''''''''''''''''''''''''''''
    Public Sub CallComScripting(ByRef rdObjects As rdPlugin.rdServerObjects)
        'This sample demonstrates one way to call a COM object.
        Dim scr As Object = CreateObject("MSScriptControl.ScriptControl")
        scr.Language = "VBScript"
        Dim x As String = scr.Eval("1 + 2")
        scr = Nothing
    End Sub

End Class
